#!/bin/ksh

DEFAULT_STORK_HOME=/usr/local/stork

PROG=stork-install

#-----------------------------------------------------------------------

mkConfig(){
	if [[ x$STORK_HOME = "x" ]] then
		echo "cant access config file " ; exit 1;
	else
		touch $STORK_HOME/etc/stork_config
		
		if [[ $? -ne 0 ]] then
			echo "cant access config file "; exit 1;
		fi

		cat > $STORK_HOME/etc/stork_config <<EOF
######################################################################
##
##  stork_config
##
######################################################################
RELEASE_DIR             =  $STORK_HOME
EOF

cat $STORK_HOME/etc/stork_config.template >> $STORK_HOME/etc/stork_config

echo "$PROG: creating configuration file"
echo 
echo " Please set STORK_CONFIG environment variable!"
echo
echo export STORK_CONFIG=$STORK_HOME/etc/stork_config
echo
echo By default, stork_server will search 
echo "				/etc/stork,"
echo "				/usr/local/etc,"
echo "				 and \$GLOBUS_LOCATION/etc"
echo "for \"stork_config\" file if \"STORK_CONFIG\" environment variable is not defined!"
echo
echo " Please set PATH environment variable to Stork binaries"
echo
echo export PATH=\$PATH:$STORK_HOME/bin:$STORK_HOME/sbin
echo

fi

}

# ---------------------------------------------------------------------------

cpRelease(){


if [[ -d $STORK_HOME ]]; then
                touch $STORK_HOME/.stork_home
                if [[ $? -ne 0 ]]; then
                        echo "No write access "
                        exit 1
                fi
        else
		mkdir -p $STORK_HOME >/dev/null 2>&1
		if [[ $? -ne 0 ]]; then
			echo "$PROG: Error"
			echo
			echo "Cant create installation directory ( $STORK_HOME )"
			echo "Please provide installation directory as an argument"
			echo
			echo "$PROG <installation-directory>"
			exit 1
		fi
        fi



RELEASE=`pwd`/release.tar.gz

if [[ -f $RELEASE ]] ; then
	echo "$PROG: extracting binaries"
        echo "			release_file: $RELEASE"
else
        echo "$PROG: Error"
	echo
	echo "Cant find release.tar.gz"
        exit 1
fi

cd $STORK_HOME
tar xvfz $RELEASE

cd -

}
# ---------------------------------------------------------------------------


LibExecLinks(){

cd $STORK_HOME/libexec

	ln -s stork.transfer.globus-url-copy stork.transfer.gsiftp-gsiftp
	ln -s stork.transfer.globus-url-copy stork.transfer.gsiftp-file
	ln -s stork.transfer.globus-url-copy stork.transfer.file-gsiftp
	ln -s stork.transfer.globus-url-copy stork.transfer.http-gsiftp
	ln -s stork.transfer.globus-url-copy stork.transfer.gsiftp-http
	ln -s stork.transfer.globus-url-copy stork.transfer.gsiftp-ftp
	ln -s stork.transfer.globus-url-copy stork.transfer.ftp-gsiftp
	ln -s stork.transfer.globus-url-copy stork.transfer.ftp-ftp
	ln -s stork.transfer.globus-url-copy stork.transfer.file-ftp
	ln -s stork.transfer.globus-url-copy stork.transfer.ftp-file

	ln -s stork.transfer.petashare stork.transfer.file-petashare
	ln -s stork.transfer.petashare stork.transfer.petashare-file
	ln -s stork.transfer.petashare stork.transfer.petashare-petashare


	ln -s stork.transfer.irods	stork.transfer.file-irods
	ln -s stork.transfer.irods	stork.transfer.irods-file

	ln -s stork.transfer.srb	stork.transfer.file-srb
	ln -s stork.transfer.srb	stork.transfer.srb-file
echo 
echo "Installation Complete!"
echo
echo

}
# ---------------------------------------------------------------------------
finalCheck(){

	if [[ $USER == "root" ]]
	then
		id stork 2>&1 >/dev/null

		if [[ $? -ne 0 ]]; then
			echo "Creating a new user [stork] (yes/no)?"
			read readA
			if [[ $readA != "yes" ]]; then
				exit
			else
				useradd stork
			fi
		fi
		
		echo
		echo ">> owner of \"$STORK_HOME\" is \"stork\" user !"
		chown -R stork.stork $STORK_HOME
		echo

	fi
}
# ---------------------------------------------------------------------------

if (( $# < 1 )) then
	STORK_HOME=$DEFAULT_STORK_HOME
else 
	STORK_HOME="$1"
fi

echo $STORK_HOME | grep '^/' >/dev/null
if [[ $? -ne 0 ]]; then
	STORK_HOME=`pwd`/$STORK_HOME
fi

PROG=$0

echo "Installation directory is $STORK_HOME / Proceed (yes/no)?"
read readA

if [[ $readA != "yes" ]] ; then
	echo "Usage:"
	echo "		$PROG <installation-directory>"
	echo
	exit
else
	echo "..."
fi

# ---------------------------------------------------------------------------

cpRelease


mkConfig


mkLibExecLinks

finalCheck

# ---------------------------------------------------------------------------

